library(tidyr)
data <- read.table("C:/Users/Desktop/data1", header = FALSE, sep = "", fill = TRUE)
colnames(data) <- paste0("item", 1:30)
data$person <- 1:nrow(data)
data_long <- pivot_longer(data, 
                          cols = starts_with("item"), 
                          names_to = "item", 
                          values_to = "score")

##Install Package##
install.packages("lme4")
library(lme4)
##Linear mixed-effects model##
model <- lmer(score ~ 1 + (1|person) + (1|item), data = data_long)
summary(model)

## Extract G study results ##
vc <- as.data.frame(VarCorr(model))
sigma2_p  <- vc$vcov[vc$grp == "person"]
sigma2_i  <- vc$vcov[vc$grp == "item"]
sigma2_pi <- vc$vcov[vc$grp == "Residual"]

##Define test lengths
n_items_list <- c(5, 10, 15, 20, 25, 30, 40, 50)
##Vectors for storing results
sigma2_delta <- numeric(length(n_items_list))
sigma2_Delta <- numeric(length(n_items_list))
Ep2 <- numeric(length(n_items_list))
phi <- numeric(length(n_items_list))

for (k in seq_along(n_items_list)) {
  n_i <- n_items_list[k]
  sigma2_delta[k] <- sigma2_pi / n_i                          
  sigma2_Delta[k] <- (sigma2_i / n_i) + (sigma2_pi / n_i)
  Ep2[k]          <- sigma2_p / (sigma2_p + sigma2_delta[k])
  phi[k]          <- sigma2_p / (sigma2_p + sigma2_Delta[k])
}
##Final table
d_study_table <- data.frame(
  n_i = n_items_list,
  sigma2_delta = round(sigma2_delta, 4),
  sigma2_Delta = round(sigma2_Delta, 4),
  Ep2 = round(Ep2, 4),
  phi = round(phi, 4)
)
print(d_study_table)

# Plot 1: Error variances
plot(n_items_list, sigma2_delta, type = "o", col = "blue", ylim = range(c(sigma2_delta, sigma2_Delta)),
     xlab = "Test Length (Number of Items)", ylab = "Error Variance",
     main = "Relative and Absolute Error Variance by Test Length")
lines(n_items_list, sigma2_Delta, type = "o", col = "darkgreen")
legend("topright", legend = c("Relative Error Variance (σ²δ)", "Absolute Error Variance (σ²Δ)"),
       col = c("blue", "darkgreen"), lty = 1, pch = 1)

# Plot 2: G and Phi coefficients
plot(n_items_list, Ep2, type = "o", col = "darkred", ylim = c(0,1),
     xlab = "Test Length (Number of Items)", ylab = "Coefficient",
     main = "Generalizability and Dependability Coefficients")
lines(n_items_list, phi, type = "o", col = "red")
legend("bottomright", legend = c("Ep²", "Φ"),
       col = c("darkred", "red"), lty = 1, pch = 1)